/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.entities;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.tinymediamanager.core.AbstractModelObject;
import org.tinymediamanager.scraper.util.UrlUtil;

public abstract class Person
extends AbstractModelObject {
    public static final String ACTOR_DIR = ".actors";
    @JsonProperty
    private String name = "";
    @JsonProperty
    private String character = "";
    @JsonProperty
    private String thumbUrl = "";
    @Deprecated
    @JsonProperty
    private String thumbPath = "";
    @JsonProperty
    private String entityRoot = "";
    @JsonProperty
    private int ordering = 0;
    @JsonProperty
    private String role = "";
    @JsonProperty
    protected HashMap<String, Object> ids = new HashMap(0);

    public Person() {
    }

    public Person(String name) {
        this.name = name;
    }

    public Person(String name, String character) {
        this.name = name;
        this.character = character;
    }

    public void setName(String newValue) {
        String oldValue = this.name;
        this.name = newValue;
        this.firePropertyChange("name", oldValue, newValue);
    }

    public String getName() {
        return this.name;
    }

    public String getNameForStorage() {
        String n = this.name.replace(" ", "_");
        n = n.replaceAll("([\"\\\\:<>|/?*])", "");
        String ext = UrlUtil.getExtension((String)this.thumbUrl);
        if (ext.isEmpty()) {
            ext = "jpg";
        }
        return n + "." + ext;
    }

    @Deprecated
    public Path getStoragePath() {
        if (StringUtils.isEmpty((CharSequence)this.entityRoot) || StringUtils.isEmpty((CharSequence)this.name)) {
            return null;
        }
        return Paths.get(this.entityRoot, ACTOR_DIR, this.getNameForStorage()).toAbsolutePath();
    }

    public String getCharacter() {
        return this.character;
    }

    public void setCharacter(String newValue) {
        String oldValue = this.character;
        this.character = newValue;
        this.firePropertyChange("character", oldValue, newValue);
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String newValue) {
        String oldValue = this.role;
        this.role = newValue;
        this.firePropertyChange("role", oldValue, newValue);
    }

    public String getThumbUrl() {
        return this.thumbUrl;
    }

    public void setThumbUrl(String newValue) {
        String oldValue = this.thumbUrl;
        this.thumbUrl = newValue;
        this.firePropertyChange("thumb", oldValue, newValue);
    }

    @Deprecated
    public String getThumbPath() {
        return this.thumbPath;
    }

    @Deprecated
    public void setThumbPath(String thumbPath) {
        this.thumbPath = thumbPath;
    }

    @Deprecated
    public String getEntityRoot() {
        return this.entityRoot;
    }

    @Deprecated
    public void setEntityRoot(String entityRoot) {
        this.entityRoot = entityRoot;
    }

    @Deprecated
    public void setEntityRoot(Path entityRoot) {
        if (entityRoot != null) {
            this.entityRoot = entityRoot.toString();
        }
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Person)) {
            return false;
        }
        Person cast = (Person)obj;
        return StringUtils.equals((CharSequence)this.name, (CharSequence)cast.name) && StringUtils.equals((CharSequence)this.character, (CharSequence)cast.character) && StringUtils.equals((CharSequence)this.thumbUrl, (CharSequence)cast.thumbUrl);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.name).append((Object)this.character).append((Object)this.thumbUrl).build();
    }
}

