/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.support.model.item;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import org.fourthline.cling.support.model.DIDLObject;
import org.fourthline.cling.support.model.Person;
import org.fourthline.cling.support.model.PersonWithRole;
import org.fourthline.cling.support.model.Res;
import org.fourthline.cling.support.model.container.Container;
import org.fourthline.cling.support.model.item.Item;

public class VideoItem
extends Item {
    public static final DIDLObject.Class CLASS = new DIDLObject.Class("object.item.videoItem");

    public VideoItem() {
        this.setClazz(CLASS);
    }

    public VideoItem(Item other) {
        super(other);
    }

    public VideoItem(String id, Container parent, String title, String creator, Res ... resource) {
        this(id, parent.getId(), title, creator, resource);
    }

    public VideoItem(String id, String parentID, String title, String creator, Res ... resource) {
        super(id, parentID, title, creator, CLASS);
        if (resource != null) {
            this.getResources().addAll(Arrays.asList(resource));
        }
    }

    public String getFirstGenre() {
        return (String)this.getFirstPropertyValue(DIDLObject.Property.UPNP.GENRE.class);
    }

    public String[] getGenres() {
        List list = this.getPropertyValues(DIDLObject.Property.UPNP.GENRE.class);
        return list.toArray(new String[list.size()]);
    }

    public VideoItem setGenres(String[] genres) {
        this.removeProperties(DIDLObject.Property.UPNP.GENRE.class);
        for (String genre : genres) {
            this.addProperty(new DIDLObject.Property.UPNP.GENRE(genre));
        }
        return this;
    }

    public String getDescription() {
        return (String)this.getFirstPropertyValue(DIDLObject.Property.DC.DESCRIPTION.class);
    }

    public VideoItem setDescription(String description) {
        this.replaceFirstProperty(new DIDLObject.Property.DC.DESCRIPTION(description));
        return this;
    }

    public String getLongDescription() {
        return (String)this.getFirstPropertyValue(DIDLObject.Property.UPNP.LONG_DESCRIPTION.class);
    }

    public VideoItem setLongDescription(String description) {
        this.replaceFirstProperty(new DIDLObject.Property.UPNP.LONG_DESCRIPTION(description));
        return this;
    }

    public Person getFirstProducer() {
        return (Person)this.getFirstPropertyValue(DIDLObject.Property.UPNP.PRODUCER.class);
    }

    public Person[] getProducers() {
        List list = this.getPropertyValues(DIDLObject.Property.UPNP.PRODUCER.class);
        return list.toArray(new Person[list.size()]);
    }

    public VideoItem setProducers(Person[] persons) {
        this.removeProperties(DIDLObject.Property.UPNP.PRODUCER.class);
        for (Person p : persons) {
            this.addProperty(new DIDLObject.Property.UPNP.PRODUCER(p));
        }
        return this;
    }

    public String getRating() {
        return (String)this.getFirstPropertyValue(DIDLObject.Property.UPNP.RATING.class);
    }

    public VideoItem setRating(String rating) {
        this.replaceFirstProperty(new DIDLObject.Property.UPNP.RATING(rating));
        return this;
    }

    public PersonWithRole getFirstActor() {
        return (PersonWithRole)this.getFirstPropertyValue(DIDLObject.Property.UPNP.ACTOR.class);
    }

    public PersonWithRole[] getActors() {
        List list = this.getPropertyValues(DIDLObject.Property.UPNP.ACTOR.class);
        return list.toArray(new PersonWithRole[list.size()]);
    }

    public VideoItem setActors(PersonWithRole[] persons) {
        this.removeProperties(DIDLObject.Property.UPNP.ACTOR.class);
        for (PersonWithRole p : persons) {
            this.addProperty(new DIDLObject.Property.UPNP.ACTOR(p));
        }
        return this;
    }

    public Person getFirstDirector() {
        return (Person)this.getFirstPropertyValue(DIDLObject.Property.UPNP.DIRECTOR.class);
    }

    public Person[] getDirectors() {
        List list = this.getPropertyValues(DIDLObject.Property.UPNP.DIRECTOR.class);
        return list.toArray(new Person[list.size()]);
    }

    public VideoItem setDirectors(Person[] persons) {
        this.removeProperties(DIDLObject.Property.UPNP.DIRECTOR.class);
        for (Person p : persons) {
            this.addProperty(new DIDLObject.Property.UPNP.DIRECTOR(p));
        }
        return this;
    }

    public Person getFirstPublisher() {
        return (Person)this.getFirstPropertyValue(DIDLObject.Property.DC.PUBLISHER.class);
    }

    public Person[] getPublishers() {
        List list = this.getPropertyValues(DIDLObject.Property.DC.PUBLISHER.class);
        return list.toArray(new Person[list.size()]);
    }

    public VideoItem setPublishers(Person[] publishers) {
        this.removeProperties(DIDLObject.Property.DC.PUBLISHER.class);
        for (Person publisher : publishers) {
            this.addProperty(new DIDLObject.Property.DC.PUBLISHER(publisher));
        }
        return this;
    }

    public String getLanguage() {
        return (String)this.getFirstPropertyValue(DIDLObject.Property.DC.LANGUAGE.class);
    }

    public VideoItem setLanguage(String language) {
        this.replaceFirstProperty(new DIDLObject.Property.DC.LANGUAGE(language));
        return this;
    }

    public URI getFirstRelation() {
        return (URI)this.getFirstPropertyValue(DIDLObject.Property.DC.RELATION.class);
    }

    public URI[] getRelations() {
        List list = this.getPropertyValues(DIDLObject.Property.DC.RELATION.class);
        return list.toArray(new URI[list.size()]);
    }

    public VideoItem setRelations(URI[] relations) {
        this.removeProperties(DIDLObject.Property.DC.RELATION.class);
        for (URI relation : relations) {
            this.addProperty(new DIDLObject.Property.DC.RELATION(relation));
        }
        return this;
    }
}

