/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.support.model.item;

import java.util.Arrays;
import java.util.List;
import org.fourthline.cling.support.model.DIDLObject;
import org.fourthline.cling.support.model.PersonWithRole;
import org.fourthline.cling.support.model.Res;
import org.fourthline.cling.support.model.StorageMedium;
import org.fourthline.cling.support.model.container.Container;
import org.fourthline.cling.support.model.item.Item;

public class PlaylistItem
extends Item {
    public static final DIDLObject.Class CLASS = new DIDLObject.Class("object.item.playlistItem");

    public PlaylistItem() {
        this.setClazz(CLASS);
    }

    public PlaylistItem(Item other) {
        super(other);
    }

    public PlaylistItem(String id, Container parent, String title, String creator, Res ... resource) {
        this(id, parent.getId(), title, creator, resource);
    }

    public PlaylistItem(String id, String parentID, String title, String creator, Res ... resource) {
        super(id, parentID, title, creator, CLASS);
        if (resource != null) {
            this.getResources().addAll(Arrays.asList(resource));
        }
    }

    public PersonWithRole getFirstArtist() {
        return (PersonWithRole)this.getFirstPropertyValue(DIDLObject.Property.UPNP.ARTIST.class);
    }

    public PersonWithRole[] getArtists() {
        List list = this.getPropertyValues(DIDLObject.Property.UPNP.ARTIST.class);
        return list.toArray(new PersonWithRole[list.size()]);
    }

    public PlaylistItem setArtists(PersonWithRole[] artists) {
        this.removeProperties(DIDLObject.Property.UPNP.ARTIST.class);
        for (PersonWithRole artist : artists) {
            this.addProperty(new DIDLObject.Property.UPNP.ARTIST(artist));
        }
        return this;
    }

    public String getFirstGenre() {
        return (String)this.getFirstPropertyValue(DIDLObject.Property.UPNP.GENRE.class);
    }

    public String[] getGenres() {
        List list = this.getPropertyValues(DIDLObject.Property.UPNP.GENRE.class);
        return list.toArray(new String[list.size()]);
    }

    public PlaylistItem setGenres(String[] genres) {
        this.removeProperties(DIDLObject.Property.UPNP.GENRE.class);
        for (String genre : genres) {
            this.addProperty(new DIDLObject.Property.UPNP.GENRE(genre));
        }
        return this;
    }

    public String getDescription() {
        return (String)this.getFirstPropertyValue(DIDLObject.Property.DC.DESCRIPTION.class);
    }

    public PlaylistItem setDescription(String description) {
        this.replaceFirstProperty(new DIDLObject.Property.DC.DESCRIPTION(description));
        return this;
    }

    public String getLongDescription() {
        return (String)this.getFirstPropertyValue(DIDLObject.Property.UPNP.LONG_DESCRIPTION.class);
    }

    public PlaylistItem setLongDescription(String description) {
        this.replaceFirstProperty(new DIDLObject.Property.UPNP.LONG_DESCRIPTION(description));
        return this;
    }

    public String getLanguage() {
        return (String)this.getFirstPropertyValue(DIDLObject.Property.DC.LANGUAGE.class);
    }

    public PlaylistItem setLanguage(String language) {
        this.replaceFirstProperty(new DIDLObject.Property.DC.LANGUAGE(language));
        return this;
    }

    public StorageMedium getStorageMedium() {
        return (StorageMedium)((Object)this.getFirstPropertyValue(DIDLObject.Property.UPNP.STORAGE_MEDIUM.class));
    }

    public PlaylistItem setStorageMedium(StorageMedium storageMedium) {
        this.replaceFirstProperty(new DIDLObject.Property.UPNP.STORAGE_MEDIUM(storageMedium));
        return this;
    }

    public String getDate() {
        return (String)this.getFirstPropertyValue(DIDLObject.Property.DC.DATE.class);
    }

    public PlaylistItem setDate(String date) {
        this.replaceFirstProperty(new DIDLObject.Property.DC.DATE(date));
        return this;
    }
}

