/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.protocol;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.fourthline.cling.UpnpService;
import org.fourthline.cling.transport.RouterException;
import org.seamless.util.Exceptions;

public abstract class SendingAsync
implements Runnable {
    private static final Logger log = Logger.getLogger(UpnpService.class.getName());
    private final UpnpService upnpService;

    protected SendingAsync(UpnpService upnpService) {
        this.upnpService = upnpService;
    }

    public UpnpService getUpnpService() {
        return this.upnpService;
    }

    @Override
    public void run() {
        try {
            this.execute();
        }
        catch (Exception ex) {
            Throwable cause = Exceptions.unwrap((Throwable)ex);
            if (cause instanceof InterruptedException) {
                log.log(Level.INFO, "Interrupted protocol '" + this.getClass().getSimpleName() + "': " + ex, cause);
            }
            throw new RuntimeException("Fatal error while executing protocol '" + this.getClass().getSimpleName() + "': " + ex, ex);
        }
    }

    protected abstract void execute() throws RouterException;

    public String toString() {
        return "(" + this.getClass().getSimpleName() + ")";
    }
}

