/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.model.resource;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.fourthline.cling.model.ExpirationDetails;

public class Resource<M> {
    private URI pathQuery;
    private M model;

    public Resource(URI pathQuery, M model) {
        try {
            this.pathQuery = new URI(null, null, pathQuery.getPath(), pathQuery.getQuery(), null);
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
        this.model = model;
        if (model == null) {
            throw new IllegalArgumentException("Model instance must not be null");
        }
    }

    public URI getPathQuery() {
        return this.pathQuery;
    }

    public M getModel() {
        return this.model;
    }

    public boolean matches(URI pathQuery) {
        return pathQuery.equals(this.getPathQuery());
    }

    public void maintain(List<Runnable> pendingExecutions, ExpirationDetails expirationDetails) {
    }

    public void shutdown() {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Resource resource = (Resource)o;
        return this.getPathQuery().equals(resource.getPathQuery());
    }

    public int hashCode() {
        return this.getPathQuery().hashCode();
    }

    public String toString() {
        return "(" + this.getClass().getSimpleName() + ") URI: " + this.getPathQuery();
    }
}

