/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.model.message.header;

import org.fourthline.cling.model.message.header.InvalidHeaderException;
import org.fourthline.cling.model.message.header.UpnpHeader;
import org.fourthline.cling.model.types.NamedServiceType;
import org.fourthline.cling.model.types.ServiceType;
import org.fourthline.cling.model.types.UDN;

public class ServiceUSNHeader
extends UpnpHeader<NamedServiceType> {
    public ServiceUSNHeader() {
    }

    public ServiceUSNHeader(UDN udn, ServiceType serviceType) {
        this.setValue(new NamedServiceType(udn, serviceType));
    }

    public ServiceUSNHeader(NamedServiceType value) {
        this.setValue(value);
    }

    @Override
    public void setString(String s) throws InvalidHeaderException {
        try {
            this.setValue(NamedServiceType.valueOf(s));
        }
        catch (Exception ex) {
            throw new InvalidHeaderException("Invalid service USN header value, " + ex.getMessage());
        }
    }

    @Override
    public String getString() {
        return ((NamedServiceType)this.getValue()).toString();
    }
}

